var core = {};

core.inject = function (e) {
  if (config.addon.state === "ON") {
    var code = config.options;
    app.tab.inject(e.tabId, {
      "allFrames": false,
      "frameId": e.frameId,
      "matchAboutBlank": true,
      "runAt": "document_start",
      "code": "var options = " + JSON.stringify(code) + ';'
    }, {
      "allFrames": false,
      "frameId": e.frameId,
      "matchAboutBlank": true,
      "runAt": "document_start",
      "file": "/data/content_script/inject.js"
    });
  }
};

app.button.clicked(function () {
  config.addon.state = config.addon.state === "ON" ? "OFF" : "ON";
  app.button.icon(config.addon.state);
});

app.contextmenu.clicked(function (e) {
  if (e.menuItemId === "change-geolocation-test-page") {
    app.tab.open(config.test.page);
  }
});

app.options.receive("changed", function (o) {
  config.set(o.pref, o.value);
  app.options.send("set", {"pref": o.pref, "value": config.get(o.pref)});
});

app.options.receive("get", function (pref) {
  app.options.send("set", {
    "pref": pref,
    "value": config.get(pref)
  });
});

chrome.webNavigation.onCommitted.addListener(core.inject);

app.options.receive("test", function () {app.tab.open(config.test.page)});
app.options.receive("support", function () {app.tab.open(app.homepage())});
app.options.receive("donation", function () {app.tab.open(app.homepage() + "?reason=support")});

window.setTimeout(function () {
  app.contextmenu.create();
  app.button.icon(config.addon.state);
}, 300);
